/*
 * Decompiled with CFR 0.152.
 */
package Cep_Vakit;

import Cep_Vakit.Astrometric;
import Cep_Vakit.EarthHeading;
import Cep_Vakit.EarthPosition;
import Cep_Vakit.EclipticPosition;
import Cep_Vakit.EquitorialPosition;
import Cep_Vakit.Float;
import Cep_Vakit.HorizontalPosition;
import Cep_Vakit.Preferences;
import Cep_Vakit.UTCDate;

public class SunMoonPosition {
    private static final EarthPosition[] a_compass_EarthPosition_array1d_static_fld = new EarthPosition[]{new EarthPosition(32, 55, 35, 4), new EarthPosition(31, 46, 35, 14), new EarthPosition(21, 25, 39, 49)};
    private UTCDate a_compass_UTCDate_fld;
    private HorizontalPosition a_compass_HorizontalPosition_fld;
    private HorizontalPosition b;
    private Float a_henson_midp_Float_fld;
    private EarthHeading a_compass_EarthHeading_fld;

    public SunMoonPosition(Preferences preferences) {
        this.a_compass_UTCDate_fld = new UTCDate(preferences.TimeOffset);
        EarthPosition earthPosition = new EarthPosition(preferences.LatMinutes, preferences.LongMinutes);
        Float float_ = this.a_compass_UTCDate_fld.getMJD();
        EclipticPosition eclipticPosition = Astrometric.sunPosition(float_);
        EquitorialPosition equitorialPosition = eclipticPosition.toEquitorialPosition();
        this.a_compass_HorizontalPosition_fld = equitorialPosition.toHorizontalPosition(earthPosition, float_);
        EclipticPosition eclipticPosition2 = Astrometric.moonPosition(float_);
        EquitorialPosition equitorialPosition2 = eclipticPosition2.toEquitorialPosition();
        this.b = equitorialPosition2.toHorizontalPosition(earthPosition, float_);
        Float float_2 = eclipticPosition.getLongitude().Sub(eclipticPosition2.getLongitude());
        this.a_henson_midp_Float_fld = Float.cos(Float.PI.Sub(float_2)).Add(new Float(1L)).Div(new Float(2L));
        this.a_compass_EarthHeading_fld = preferences.PrayerFocus == 0 ? null : earthPosition.toEarthHeading(a_compass_EarthPosition_array1d_static_fld[preferences.PrayerFocus - 1]);
    }

    public UTCDate getUTCDate() {
        return this.a_compass_UTCDate_fld;
    }

    public HorizontalPosition getSunPosition() {
        return this.a_compass_HorizontalPosition_fld;
    }

    public HorizontalPosition getMoonPosition() {
        return this.b;
    }

    public Float getMoonPhase() {
        return this.a_henson_midp_Float_fld;
    }

    public EarthHeading getPrayerHeading() {
        return this.a_compass_EarthHeading_fld;
    }
}

